/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;



public class PRIVATECHATFILE extends MESSAGE {

  public final static String NUMBER = "NUMBER";
  public final static String USERID = "USERID";
  public final static String REMOTE_SESSION_ID = "REMOTE_SESSION_ID";
  public final static String REMOTE_NICKNAME = "REMOTE_NICKNAME";
  public final static String FILENAME = "FILENAME";
  public final static String ABSOLUTE_FILENAME = "ABSOLUTE_FILENAME";
  public final static String FILESIZE = "FILESIZE";
  public final static String MESSAGE = "MESSAGE";

  /**
   * Ein Datenbankschlüssel
   */
  private Long number;
  private String userid;
  private String remoteSessionId;
  private String remoteNickname;
  private String filename;
  private String absoluteFilename;
  private Long filesize;
  private String message;

  public String getUserid() {
    return userid;
  }



  public void setUserid(String userid) {
    this.userid = userid;
  }



  public String getRemoteSessionId() {
    return remoteSessionId;
  }



  public void setRemoteSessionId(String remoteSessionId) {
    this.remoteSessionId = remoteSessionId;
  }



  public String getFilename() {
    return filename;
  }



  public void setFilename(String filename) {
    this.filename = filename;
  }



  public String getAbsoluteFilename() {
    return absoluteFilename;
  }



  public void setAbsoluteFilename(String absoluteFilename) {
    this.absoluteFilename = absoluteFilename;
  }



  public Long getFilesize() {
    return filesize;
  }



  public void setFilesize(Long filesize) {
    this.filesize = filesize;
  }



  public String getMessage() {
    return message;
  }



  public void setMessage(String message) {
    this.message = message;
  }



  public Long getNumber() {
    return number;
  }



  public void setNumber(Long number) {
    this.number = number;
  }



  public String getRemoteNickname() {
    return remoteNickname;
  }



  public void setRemoteNickname(String remoteNickname) {
    this.remoteNickname = remoteNickname;
  }



  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }
}
