/**
 *  Copyright © 2026, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;



public class RoomlistSerializer implements JsonSerializer<ROOMLIST> {

  @Override
  public JsonElement serialize(ROOMLIST roomlist, Type type, JsonSerializationContext context) {

    JsonObject jsonObject = new JsonObject();
    JsonObject dataset = new JsonObject();
    JsonArray record = new JsonArray();

    for (Room room : roomlist.getRoom()) {
      JsonObject objectRoom = new JsonObject();

      objectRoom.add(Room.ROOM, context.serialize(room.getChatid()));
      objectRoom.add(Room.ROOMTYPE, context.serialize(room.getRoomtype()));
      objectRoom.add(Room.OWNER, context.serialize(room.getOwner()));
      objectRoom.add(Room.ENTRY, context.serialize(room.getEntry()));
      objectRoom.add(Room.LIFETIME, context.serialize(room.getLifetime()));

      record.add(objectRoom);
    }

    dataset.add(ROOMLIST.ROOMLIST, context.serialize(record));

    jsonObject.add("HEADER", context.serialize(roomlist.getHeader()));
    jsonObject.add("COMMAND", context.serialize(roomlist.getCommand()));
    jsonObject.add("DATASET", context.serialize(dataset));

    return jsonObject;

  }

}
