/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



/**
 * Ein neuer User meldet sich an.
 * 
 * @author llange
 *
 */
public class SIGNIN extends MESSAGE {

  public final static String EMAIL = USER.EMAIL;
  public final static String USERID = USER.USERID;
  public final static String NEUES_PASSWORD = "NEUES_PASSWORD";
  public final static String CONFIRMATION_KEY = "CONFIRMATION_KEY";
  public final static String NICKNAME = USER.NICKNAME;
  public final static String PASSWORD = USER.PASSWORD;
  public final static String FOREGROUND_COLOR = USER.FOREGROUND_COLOR;
  public final static String BACKGROUND_COLOR = USER.BACKGROUND_COLOR;

  private String email;
  private String userid;
  private String neuesPassword;
  private String confirmationKey;
  private String nickname;
  private String password;
  private Integer backgroundColor;
  private Integer foregroundColor;

  public final Integer getBackgroundColor() {
    return backgroundColor;
  }



  public final String getConfirmationKey() {
    return confirmationKey;
  }



  public final String getEmail() {
    return email;
  }



  public final Integer getForegroundColor() {
    return foregroundColor;
  }



  public final String getNeuesPassword() {
    return neuesPassword;
  }



  public final String getNickname() {
    return nickname;
  }



  public final String getPassword() {
    return password;
  }



  public final String getUserid() {
    return userid;
  }



  public final void setBackgroundColor(Integer backgroundColor) {
    this.backgroundColor = backgroundColor;
  }



  public final void setConfirmationKey(String confirmationKey) {
    this.confirmationKey = confirmationKey;
  }



  public final void setEmail(String email) {
    this.email = email;
  }



  public final void setForegroundColor(Integer forgroundColor) {
    this.foregroundColor = forgroundColor;
  }



  public final void setNeuesPassword(String neuesPassword) {
    this.neuesPassword = neuesPassword;
  }



  public final void setNickname(String nickname) {
    this.nickname = nickname;
  }



  public final void setPassword(String password) {
    this.password = password;
  }



  public final void setUserid(String userid) {
    this.userid = userid;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder().disableHtmlEscaping();
    Gson gson = builder.registerTypeAdapter(SIGNIN.class, new SigninSerializer()).create();
    return gson.toJson(this);
  }

}
