/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public abstract class USER extends MESSAGE {

  public final static String EMAIL = "EMAIL";
  public final static String USERID = "USERID";
  public final static String PASSWORD = "PASSWORD";
  public final static String NEUES_PASSWORD = "NEUES_PASSWORD";
  public final static String CONFIRMATION_KEY = "CONFIRMATION_KEY";
  public final static String NICKNAME = "NICKNAME";
  public final static String FOREGROUND_COLOR = "FOREGROUND_COLOR";
  public final static String BACKGROUND_COLOR = "BACKGROUND_COLOR";
  public final static String VOLUME = "VOLUME";
  public final static String ONCALL = "ONCALL";
  public final static String IP = "IP";
  public final static String AES = "AES";

  private String userid;
  private String eMail;
  private String password;
  private String nickname;
  private Integer fgColor;
  private Integer bgColor;
  private Integer volume;
  private Boolean oncall;
  private String neuesPassword;
  private String confirmationKey;
  String ip;
  String session;

  public Integer getBackgroundColor() {
    return bgColor;
  }



  public String getConfirmationKey() {
    return confirmationKey;
  }



  /**
   * Die eMail ist immer eindeutig.
   * 
   * @return eMail
   */
  public final String getEmail() {
    return eMail;
  }



  public Integer getForegroundColor() {
    return fgColor;
  }



  public abstract String getIp();



  public String getNeuesPassword() {
    return neuesPassword;
  }



  public String getNickname() {
    return nickname;
  }



  public final String getPassword() {
    return password;
  }



  public abstract String getSession();



  /**
   * Jeder User hat eine eindeutige id.
   * 
   * @return userid
   */
  public final String getUserid() {
    return userid;
  }



  public Integer getVolume() {
    return volume;
  }



  public Boolean isOncall() {
    return oncall;
  }



  public void setBackgroundColor(Integer color) {
    bgColor = color;
  }



  public void setConfirmationKey(String value) {
    confirmationKey = value;
  }



  public final void setEmail(String value) {
    eMail = value;
  }



  public void setForegroundColor(Integer color) {
    fgColor = color;
  }



  public void setNeuesPassword(String value) {
    neuesPassword = value;
  }



  public void setNickname(String value) {
    nickname = value;
  }



  public void setOncall(Boolean oncall) {
    this.oncall = oncall;
  }



  public final void setPassword(String value) {
    password = value;
  }



  public final void setUserid(String value) {
    userid = value;
  }



  public void setVolume(Integer volume) {
    this.volume = volume;
  }
}
