/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



public class USERONLINELIST extends MESSAGE {

  public final static String USERONLINELIST = "USERONLINELIST";
  public final static String USERID = "USERID";

  private UserOnline[] useronline;
  private String userid;

  public void setUserOnline(UserOnline[] value) {
    useronline = value;
  }



  public UserOnline[] getUserOnline() {
    return useronline;
  }



  public void setUserid(String value) {
    userid = value;
  }



  public String getUserid() {
    return userid;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeHierarchyAdapter(USERONLINELIST.class, new UseronlinelistSerializer());
    builder.registerTypeHierarchyAdapter(UserOnline.class, new UserOnlineSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }
}
