/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

import com.google.gson.Gson;
import net.javacomm.protocol.Language;

public class TransferUser {

  private String userid;
  private String mail;
  private String nickname;
  private Integer benutzerstatus;
  private Integer volume;
  private Integer playervolume;
  private Integer iptvvolume;
  private Boolean oncall;
  private Sprachguete telefonpuffer;
  private String speaker;
  private String mikrofon;
  private Boolean chatdenied;
  private Boolean chattooltip;
  private String chatdownloaddir;
  private String chatuploaddir;
  private Integer rekorderport;
  private Boolean onrekord;
  private Boolean onprojektor;
  private Helado helado;
  private Language language;
  private Boolean ldelete;





  public Language getLanguage() {
    return language;
  }



  public void setLanguage(Language language) {
    this.language = language;
  }



  public Boolean getOncall() {
    return oncall;
  }



  public void setOncall(Boolean oncall) {
    this.oncall = oncall;
  }

  public String getUserid() {
    return userid;
  }



  public void setUserid(String userid) {
    this.userid = userid;
  }



  public String getMail() {
    return mail;
  }



  public void setMail(String mail) {
    this.mail = mail;
  }


  @Override
  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }



  public Integer getVolume() {
    return volume;
  }



  public void setVolume(Integer volume) {
    this.volume = volume;
  }



  public Integer getBenutzerstatus() {
    return benutzerstatus;
  }



  public void setBenutzerstatus(Integer benutzerstatus) {
    this.benutzerstatus = benutzerstatus;
  }



  public Integer getPlayervolume() {
    return playervolume;
  }



  public void setPlayervolume(Integer playervolume) {
    this.playervolume = playervolume;
  }



  public Sprachguete getTelefonpuffer() {
    return telefonpuffer;
  }



  public void setTelefonpuffer(Sprachguete telefonpuffer) {
    this.telefonpuffer = telefonpuffer;
  }




  public Helado getHelado() {
    return helado;
  }



  public void setHelado(Helado helado) {
    this.helado = helado;
  }



  public String getSpeaker() {
    return speaker;
  }



  public void setSpeaker(String speaker) {
    this.speaker = speaker;
  }



  public String getMikrofon() {
    return mikrofon;
  }



  public void setMikrofon(String mikrofon) {
    this.mikrofon = mikrofon;
  }



  @Deprecated
  public Integer getRekorderport() {
    return rekorderport;
  }



  @Deprecated
  public void setRekorderport(Integer rekorderport) {
    this.rekorderport = rekorderport;
  }



  public Boolean getOnrekord() {
    return onrekord;
  }



  public void setOnrekord(Boolean onrekord) {
    this.onrekord = onrekord;
  }



  public Boolean getChatdenied() {
    return chatdenied;
  }



  public void setChatdenied(Boolean chatdenied) {
    this.chatdenied = chatdenied;
  }



  public Boolean getOnprojektor() {
    return onprojektor;
  }



  public void setOnprojektor(Boolean onprojektor) {
    this.onprojektor = onprojektor;
  }



  public Integer getIptvvolume() {
    return iptvvolume;
  }



  public void setIptvvolume(Integer iptvvolume) {
    this.iptvvolume = iptvvolume;
  }



  public Boolean getChattooltip() {
    return chattooltip;
  }



  public void setChattooltip(Boolean chattooltip) {
    this.chattooltip = chattooltip;
  }



  public String getChatdownloaddir() {
    return chatdownloaddir;
  }



  public void setChatdownloaddir(String chatdownloaddir) {
    this.chatdownloaddir = chatdownloaddir;
  }



  public String getChatuploaddir() {
    return chatuploaddir;
  }



  public void setChatuploaddir(String chatuploaddir) {
    this.chatuploaddir = chatuploaddir;
  }



  public Boolean getLdelete() {
    return ldelete;
  }



  public void setLdelete(Boolean ldelete) {
    this.ldelete = ldelete;
  }



  public String getNickname() {
    return nickname;
  }



  public void setNickname(String nickname) {
    this.nickname = nickname;
  }

}
