package net.javacomm.transfer;

import static org.junit.jupiter.api.Assertions.assertEquals;
import com.google.gson.Gson;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;



public class TestPhone {

  TransferPhone phone;
  Gson gson;

  @BeforeEach
  public void setUp() {
    phone = new TransferPhone();
    gson = new Gson();
  }



  @Test
  public void serialize() {
    phone.setUid("12345678");
    phone.setVolume(100);

    String result = phone.toString();
    assertEquals("{\"uid\":\"12345678\",\"volume\":100}", result);

  }



  @Test
  public void deserialize() {
    String result = "{\"uid\":\"12345678\",\"volume\":100}";
    phone = gson.fromJson(result, TransferPhone.class);
    assertEquals("12345678", phone.getUid());
    assertEquals(100, phone.getVolume());

  }

}
