package net.javacomm.transfer;

import static org.junit.jupiter.api.Assertions.assertEquals;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;



public class TestTransferOutdated {

  TransferOutdated outdated;
  GsonBuilder builder;
  Gson gson;

  @BeforeEach
  public void setUp() {
    outdated = new TransferOutdated();
    builder = new GsonBuilder();
    gson = builder.create();
  }



  @Test
  public void serialize() {
    outdated.setProgrammversion("PR-210806-PR1");
    String result = gson.toJson(outdated);
    assertEquals("{\"programmversion\":\"PR-210806-PR1\"}", result);
  }



  @Test
  public void deserialize() {
    String encoded = "{\"programmversion\":\"PR-210806-PR1\"}";
    TransferOutdated outdated = gson.fromJson(encoded, TransferOutdated.class);
    assertEquals("PR-210806-PR1", outdated.getProgrammversion());
  }

}
