package net.javacomm.transfer;

import static org.junit.jupiter.api.Assertions.assertEquals;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TreeMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;



public class TestTransferTelko {

  TransferTelko telko;
  LocalTime localtime;
  ZonedDateTime datetime;
  Date date;
  Gson gson;
  GregorianCalendar gregor;

  @BeforeEach
  public void setUp() {
    telko = new TransferTelko();

    gregor = new GregorianCalendar(2022, 7, 18, 15, 30, 00);
    gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, new ZonedDateTimeDeserializer())
        .create();
  }



  @Test
  public void serializeLocalDateTime() {
    telko.setKonferenzraum("bis zu 30 Zeichen");
    telko.setOrganisator("louisxiv");

    datetime = ZonedDateTime.of(2022, 8, 18, 15, 30, 0, 0, ZoneId.systemDefault());
    date = Date.from(datetime.toInstant());
    assertEquals(1660829400000L, date.getTime());
  }



  @Test
  public void serialize() {
    telko.setKonferenzraum("bis zu 30 Zeichen");
    telko.setOrganisator("louisxiv");
    datetime = ZonedDateTime.of(2022, 8, 18, 15, 30, 0, 0, ZoneId.systemDefault());

    telko.setAblaufdatum(datetime);
    assertEquals(
        "{\"konferenzraum\":\"bis zu 30 Zeichen\",\"organisator\":\"louisxiv\",\"ablaufdatum\":1660829400000}",
        telko.toString()
    );

  }



  @Test
  public void deserialize() {
    telko = gson.fromJson(
        "{\"konferenzraum\":\"Telko Projektbesprechung\",\"organisator\":\"12345678\",\"ablaufdatum\":1660829400000}",
        TransferTelko.class
    );

    GregorianCalendar gregor = new GregorianCalendar();
    ZonedDateTime ablaufdatum = telko.getAblaufdatum();
    assertEquals("Telko Projektbesprechung", telko.getKonferenzraum());
    assertEquals("12345678", telko.getOrganisator());
    assertEquals(15, ablaufdatum.getHour(), "Stunde 30");
    assertEquals(30, ablaufdatum.getMinute(), "Minute 30");
    assertEquals(8, ablaufdatum.getMonthValue(), "Monat August");
    assertEquals(2022, ablaufdatum.getYear(), "Jahr");
    assertEquals(18, ablaufdatum.getDayOfMonth(), "Tag");
  }



  @Test
  public void serializeSortedMap() {

    TreeMap<String, String> map = new TreeMap<>();
    map.put("struppi", "Mono");
    map.put("Luis", "Lange");

    String result = gson.toJson(map);
    assertEquals("{\"Luis\":\"Lange\",\"struppi\":\"Mono\"}", result);

  }

}
