/**
 * This software is released as part of the Pumpernickel project.
 * 
 * All com.pump resources in the Pumpernickel project are distributed under the
 * MIT License:
 * https://github.com/mickleness/pumpernickel/raw/master/License.txt
 * 
 * More information about the Pumpernickel project is available here:
 * https://mickleness.github.io/pumpernickel/
 */
package com.pump.icon;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.Icon;

import com.pump.blog.ResourceSample;

/**
 * A plus sign.
 * 
 * <!-- ======== START OF AUTOGENERATED SAMPLES ======== -->
 * <p>
 * <img src=
 * "https://github.com/mickleness/pumpernickel/raw/master/resources/samples/PlusIcon/sample.png"
 * alt=
 * "new&#160;com.pump.swing.resources.PlusIcon(14,&#160;14,&#160;2,&#160;java.awt.Color.gray)"
 * > <!-- ======== END OF AUTOGENERATED SAMPLES ======== -->
 *
 * @see MinusIcon
 */
@ResourceSample(sample = { "new com.pump.swing.resources.PlusIcon(14, 14, 2, java.awt.Color.gray)" })
public class PlusIcon implements Icon {
	final int width, height, strokeWidth;
	final Color color;

	public PlusIcon(int width, int height) {
		this(width, height, 2, null);
	}

	public PlusIcon(int width, int height, int strokeWidth, Color color) {
		this.width = width;
		this.height = height;
		this.strokeWidth = strokeWidth;
		this.color = color;
	}

	public int getIconHeight() {
		return height;
	}

	public int getIconWidth() {
		return width;
	}

	public void paintIcon(Component c, Graphics g0, int x, int y) {
		Graphics2D g = (Graphics2D) g0;
		g.setStroke(new BasicStroke(strokeWidth));
		if (color == null) {
			g.setColor(new Color(0x484848));
		} else {
			g.setColor(color);
		}
		g.drawLine(x, y + height / 2, x + width, y + height / 2);
		g.drawLine(x + width / 2, y, x + width / 2, y + height);
	}

}