/**
 * This software is released as part of the Pumpernickel project.
 * 
 * All com.pump resources in the Pumpernickel project are distributed under the
 * MIT License:
 * https://github.com/mickleness/pumpernickel/raw/master/License.txt
 * 
 * More information about the Pumpernickel project is available here:
 * https://mickleness.github.io/pumpernickel/
 */
package com.pump.icon;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;

import javax.swing.Icon;

import com.pump.blog.ResourceSample;
import com.pump.geom.StarPolygon;
import com.pump.geom.TransformUtils;

/**
 * A star icon.
 * 
 * <!-- ======== START OF AUTOGENERATED SAMPLES ======== -->
 * <p>
 * Here are some samples:
 * <table summary=
 * "Resource&#160;Samples&#160;for&#160;com.pump.swing.resources.StarIcon">
 * <tr>
 * <td></td>
 * <td><img src=
 * "https://github.com/mickleness/pumpernickel/raw/master/resources/samples/StarIcon/Filled.png"
 * alt =
 * "new&#160;com.pump.swing.resources.StarIcon(&#160;16,&#160;16,&#160;false)"></td>
 * <td><img src=
 * "https://github.com/mickleness/pumpernickel/raw/master/resources/samples/StarIcon/Empty.png"
 * alt
 * ="new&#160;com.pump.swing.resources.StarIcon(&#160;16,&#160;16,&#160;true)"></td>
 * </tr>
 * <tr>
 * <td></td>
 * <td>Filled</td>
 * <td>Empty</td>
 * </tr>
 * <tr>
 * </tr>
 * </table>
 * <!-- ======== END OF AUTOGENERATED SAMPLES ======== -->
 */
@ResourceSample(sample = {
		"new com.pump.swing.resources.StarIcon( 16, 16, false)",
		"new com.pump.swing.resources.StarIcon( 16, 16, true)" }, names = {
				"Filled", "Empty" })
public class StarIcon implements Icon {
	int width, height;

	Paint fill;
	Paint edge;

	public StarIcon(int w, int h, boolean empty) {
		this.width = w;
		this.height = h;
		if (empty) {
			fill = new GradientPaint(0, 0, new Color(255, 255, 255, 50), 0, h,
					new Color(100, 100, 100, 50));
			edge = new Color(0, 0, 0, 50);
		} else {
			fill = new GradientPaint(0, 0, new Color(255, 255, 0), 0, h,
					new Color(255, 200, 0));
			edge = new Color(0, 0, 0, 50);
		}
	}

	public int getIconHeight() {
		return height;
	}

	public int getIconWidth() {
		return width;
	}

	static StarPolygon starShape = new StarPolygon(4);

	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2 = (Graphics2D) g;

		g2.translate(x, y);
		Rectangle2D r1 = starShape.getBounds2D();
		Rectangle2D r2 = new Rectangle(1, 1, getIconWidth() - 2,
				getIconHeight() - 2);
		g2.transform(TransformUtils.createAffineTransform(r1, r2));
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL,
				RenderingHints.VALUE_STROKE_PURE);
		g2.setPaint(fill);
		g2.fill(starShape);
		g2.setPaint(edge);
		g2.setStroke(new BasicStroke(.5f, BasicStroke.CAP_ROUND,
				BasicStroke.JOIN_ROUND));
		g2.draw(starShape);
	}
}