/**
 * This software is released as part of the Pumpernickel project.
 * 
 * All com.pump resources in the Pumpernickel project are distributed under the
 * MIT License:
 * https://github.com/mickleness/pumpernickel/raw/master/License.txt
 * 
 * More information about the Pumpernickel project is available here:
 * https://mickleness.github.io/pumpernickel/
 */
package com.pump.plaf;

/**
 * Constants to indicate horizontal and vertical positions.
 *
 */
public interface PositionConstants {
	/** A constant used to indicate the horizontal position of a button. */
	static final int POS_BOTTOM = 5;
	/** A constant used to indicate the horizontal position of a button. */
	static final int POS_LEFT = 0;
	/**
	 * A constant used to indicate the horizontal or vertical position of a
	 * button.
	 */
	static final int POS_MIDDLE = 1;
	/**
	 * A constant used to indicate the horizontal or vertical position of a
	 * button.
	 */
	static final int POS_ONLY = 3;
	/** A constant used to indicate the horizontal position of a button. */
	static final int POS_RIGHT = 2;
	/** A constant used to indicate the horizontal position of a button. */
	static final int POS_TOP = 4;
}