/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

public enum Frames {

  CHATROOMS("Chatrooms"),
  INFO("Info"),
  TELEFON_EINRICHTEN("Telefon einrichten"),
  ANRUFEN("Anrufen"),
  ABNEHMEN("Empfangen"),
  TELEFONKONFERENZ("Telefonkonferenz"),
  CONFIGURE("Configure"),
  PLAYER("Player"),
  FTS("File Transfer Service"),
  FORUM("Forum"),
  PAUSENRAUM("Pausenraum"),
  GRUPPENRAUM("Gruppenraum"),
  PRIVATE_CHAT("Private Chat"),
  BESPRECHNUNGSRAUM("Besprechungsraum"),
  SCHWARZE_LISTE("Schwarze Liste"),
  ADMINISTRATOR("Administrator"),
  SCREENCAST("Bildschirmaufnahme"),
  SCREENRECEIVER("Bildschirm teilen"),
  PROJEKTOR("Projektor"),
  TELKOPROJEKTOR("Telkoprojektor"),
  LIVESTREAMS("Live Streams"),
  MASTERMIND("Mastermind");

  private String frame;

  private Frames(String value) {
    frame = value;
  }



  @Override
  public String toString() {
    return frame;
  }

}
